// Copyright 2026 Danslav Slavenskoj, Lingenic LLC
// License: CC0 1.0 - Public Domain

export const SOH: string;
export const STX: string;
export const ETX: string;
export const EOT: string;
export const SO: string;
export const SI: string;
export const DLE: string;
export const FS: string;
export const GS: string;
export const RS: string;
export const US: string;

export type HsvValue = string | HsvValue[] | HsvObject;
export type HsvObject = { [key: string]: HsvValue };

export interface HsvDocument {
  header: HsvObject | null;
  records: HsvObject[];
}

export function parse(text: string): HsvDocument;
